/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* SCR; 29.10.97; this file contains simple read/write (i.e. I/O) functions 
 * that are operating-system dependent....in this case Win32 ONLY.
 */

/* used for Extended DOS */
#ifdef DOSW32

#if defined(_MSC_VER)
# pragma data_seg("io16_c","FAR_DATA")
#elif defined(__BORLANDC__)
# pragma option -dc
#endif /* _MSC_VER etc. */


#include <xtypedef.h>

#include <memory.h>
#include <xerrcapi.h>

#include <xio.h>
#include <xepp.h>
#include <xserial.h>
#include <xpci.h>




/* --------------------------------------------------------------------------
 * Reads a stream of bytes from the port...NO BYTE ORDERING DONE HERE !!!
 * This function has no knowledge of registers.
 * -------------------------------------------------------------------------- */

bx_errtype BestXBasicRead(
    bx_handletype handle,
    bx_int8ptr pData,
    bx_int32 ulNumBytes,
    bx_int8 RegWidth)
{
  BX_TRY_VARS_NO_PROG;
  bx_int32 ulBytesRead = 0;

  BX_TRY_BEGIN {
    if (ulNumBytes) {
      assert (pData);
      BX_TRY_FAIL (BestXIsHandleConnected(handle) ? BX_E_OK : BX_E_NOT_CONNECTED);

      assert(((ulNumBytes % RegWidth) == 0) && "Boundary violation in BestXBasicRead()");

      /* must set (or at least check the reg. width */
      (void) BestXRegwidthSet(handle, RegWidth);

      switch (bx_handlearray[handle].port)
      {
       case BX_PORT_OFFLINE:
        memset( pData, 0, (size_t)ulNumBytes );
        break;

       case BX_PORT_RS232:

        /*BX_TRY (BestXSerBasicRead(handle, pData, ulNumBytes, &ulBytesRead));*/
        break;  

       case BX_PORT_PARALLEL:

         /*BX_TRY (BestXParBasicRead(handle, pData, ulNumBytes, &ulBytesRead));*/
        break;

       case BX_PORT_PCI_CONF:
       case BX_PORT_PCI_IO:
        BX_TRY (BestXPciBasicRead(handle, pData, ulNumBytes, &ulBytesRead));
        break;

       case BX_PORT_FASTHIF:
        break;

       default:
        /* no TRY, CZ */
        return BX_E_BAD_HANDLE;
      } /*lint !e788 ... not all enums used */
    }
  }

  BX_TRY_CATCH {
/* Does this function make sense? CZ */
/*     bx_TRY_RET = BestXOnReadError (handle); */

#ifdef BEST_DEBUG
    BestXLastErrorParamSet (handle, BX_ERRPAR_1, ulBytesRead);
    BestXLastErrorParamSet (handle, BX_ERRPAR_2, ulNumBytes);
    BX_TRY_RET = BX_E_PARTIAL_RCVE;
#else
    BestXLastErrorParamSet (handle, BX_ERRPAR_1, (bx_int32)BX_EERR_READ_WRITE);
    BX_TRY_RET = BX_E_ERROR;
#endif
      
  }
  
  return BX_TRY_RET;
}


/* --------------------------------------------------------------------------
 * "Blast" any number of bytes through
 * -------------------------------------------------------------------------- */

bx_errtype BestXBasicWrite(
    bx_handletype handle,
    bx_int8ptr pData,
    bx_int32 ulNumBytes,
    bx_int8 RegWidth)
{
  BX_TRY_VARS_NO_PROG;
  bx_int32 ulBytesWritten = 0;

  BX_TRY_BEGIN {
    if (ulNumBytes) {
      assert (pData);
      BX_TRY_FAIL (BestXIsHandleConnected(handle) ? BX_E_OK : BX_E_NOT_CONNECTED);

      assert(((ulNumBytes % RegWidth) == 0) && "Boundary violation in BestXBasicWrite()");
      /* must set (or at least check the reg. width */
      (void) BestXRegwidthSet(handle, RegWidth);

      switch (bx_handlearray[handle].port)
      {
       case BX_PORT_OFFLINE:
        break;

       case BX_PORT_RS232:
        /* BX_TRY (BestXSerBasicWrite( handle, pData, ulNumBytes, &ulBytesWritten));*/
        break;

       case BX_PORT_PARALLEL:
        /* BX_TRY (BestXParBasicWrite( handle, pData, ulNumBytes, &ulBytesWritten));*/
        break;

       case BX_PORT_PCI_CONF:
       case BX_PORT_PCI_IO:
        BX_TRY (BestXPciBasicWrite( handle, pData, ulNumBytes, &ulBytesWritten));
        break;

       case BX_PORT_FASTHIF:
        break;

       default:
        /* no TRY, CZ */
        return BX_E_BAD_HANDLE;
      }/*lint !e788 ... not all enums used */
    }
  }
  
  BX_TRY_CATCH {

#ifdef BEST_DEBUG
    BestXLastErrorParamSet (handle, BX_ERRPAR_1, ulBytesWritten);
    BestXLastErrorParamSet (handle, BX_ERRPAR_2, ulNumBytes);
    BX_TRY_RET = BX_E_PARTIAL_XMIT;
#else
    BestXLastErrorParamSet (handle, BX_ERRPAR_1, (bx_int32)BX_EERR_READ_WRITE);
    BX_TRY_RET = BX_E_ERROR;
#endif
      
  }
  
  return BX_TRY_RET;
}


/* only used for DOSW32 */
#endif

